VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 1  'vbDataSource
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsProduct"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public Event RefreshDataMember()
Public Event EditInProgress(ByVal v_sEditMode)

Private WithEvents m_recManagedObjects As ADODB.Recordset
Attribute m_recManagedObjects.VB_VarHelpID = -1

Private m_blnIgnoreFieldChange As Boolean
Private m_blnInFieldChange As Boolean
Private m_strManagedObjectDataMember As String
Private m_blnValidatingFieldChange As Boolean
Private m_eEditMode As ADODB.EditModeEnum
Public Property Get SupplierID() As Long

  On Error Resume Next

  SupplierID = m_recManagedObjects.Fields(g_pFieldSupplierID)

  If Err.Number <> 0 Then

    If Err.Number <> 3265 Then
       Err.Raise Err.Number, "Product.SupplierID.Get" & Err.Source, _
          Err.Description
    End If

  End If

End Property

Public Property Let SupplierID(ByVal v_lngNewSupplierID As Long)

  On Error GoTo SupplierIDLetError

  If m_blnValidatingFieldChange = True Then
     Exit Property
  End If

  If m_eEditMode = adEditInProgress Or m_eEditMode = adEditAdd Then
     m_blnIgnoreFieldChange = True
     m_recManagedObjects.Fields(g_pFieldSupplierID) = v_lngNewSupplierID

  ElseIf m_eEditMode = adEditNone Then
     Err.Raise 1001, "Supplier Let:", GetErrorText(errChangeFieldNoEdit)

  End If

  Exit Property

SupplierIDLetError:

  Err.Raise Err.Number, "Product.SupplierID.Let " & Err.Source, _
    Err.Description

End Property
Public Property Get QuantityPerUnit() As String

  On Error Resume Next

  QuantityPerUnit = m_recManagedObjects.Fields(g_pFieldQuantityPerUnit)

  If Err.Number <> 0 Then

     If Err.Number <> 3265 Then
        Err.Raise Err.Number, "Product.QuantityPerUnit.Get" & _
            Err.Source, Err.Description
     End If

  End If

End Property

Public Property Let QuantityPerUnit(ByVal v_strNewQuantityPerUnit As String)

 On Error GoTo QuantityPerUnitLetError

 If m_blnValidatingFieldChange = True Then
     Exit Property
  End If

  If m_eEditMode = adEditInProgress Or m_eEditMode = adEditAdd Then
     m_blnIgnoreFieldChange = True
     m_recManagedObjects.Fields(g_pFieldQuantityPerUnit) = v_strNewQuantityPerUnit

  ElseIf m_eEditMode = adEditNone Then
     Err.Raise 1001, "QuantityPerUnit Let:", GetErrorText(errChangeFieldNoEdit)

  End If

  Exit Property

QuantityPerUnitLetError:

  Err.Raise Err.Number, "Product.QuantityPerUnit.Let " & Err.Source, _
     Err.Description

End Property
Public Property Get UnitPrice() As Currency

  On Error Resume Next

  UnitPrice = m_recManagedObjects.Fields(g_pFieldUnitPrice)

  If Err.Number <> 0 Then

     If Err.Number <> 3265 Then
        Err.Raise Err.Number, "Product.UnitPrice.Get" & Err.Source, _
            Err.Description
     End If

  End If

End Property

Public Property Let UnitPrice(ByVal v_curNewUnitPrice As Currency)

  On Error GoTo UnitPriceLetError

  If m_blnValidatingFieldChange = True Then
     Exit Property
  End If

  If m_eEditMode = adEditInProgress Or m_eEditMode = adEditAdd Then
     m_blnIgnoreFieldChange = True
     m_recManagedObjects.Fields(g_pFieldUnitPrice) = v_curNewUnitPrice

  ElseIf m_eEditMode = adEditNone Then
     Err.Raise 1001, "UnitPrice Let:", GetErrorText(errChangeFieldNoEdit)

  End If

  Exit Property

UnitPriceLetError:

  Err.Raise Err.Number, "Product.UnitPrice.Let " & Err.Source, _
    Err.Description

End Property
Public Property Get UnitsInStock() As Long

  On Error Resume Next

  UnitsInStock = m_recManagedObjects.Fields(g_pFieldUnitsInStock)

  If Err.Number <> 0 Then

     If Err.Number <> 3265 Then
        Err.Raise Err.Number, "Product.UnitsInStock.Get" & _
            Err.Source, Err.Description
     End If

  End If

End Property

Public Property Let UnitsInStock(ByVal v_lngNewUnitsInStock As Long)

  On Error GoTo UnitsInStockLetError

  If m_blnValidatingFieldChange = True Then
     Exit Property
  End If

  If m_eEditMode = adEditInProgress Or m_eEditMode = adEditAdd Then
     m_blnIgnoreFieldChange = True
     m_recManagedObjects.Fields(g_pFieldUnitsInStock) = v_lngNewUnitsInStock

  ElseIf m_eEditMode = adEditNone Then
     Err.Raise 1001, "UnitsInStock Let:", GetErrorText(errChangeFieldNoEdit)

  End If

  Exit Property

UnitsInStockLetError:

  Err.Raise Err.Number, "Product.UnitsInStock.Let " & Err.Source, _
     Err.Description

End Property
Public Property Get UnitsOnOrder() As Long

  On Error Resume Next

  UnitsOnOrder = m_recManagedObjects.Fields(g_pFieldUnitsOnOrder)

  If Err.Number <> 0 Then

     If Err.Number <> 3265 Then
        Err.Raise Err.Number, "Product.UnitsOnOrder.Get" & Err.Source, _
        Err.Description
     End If

  End If

End Property

Public Property Let UnitsOnOrder(ByVal v_lngNewUnitsOnOrder As Long)

  On Error GoTo UnitsOnOrderLetError

  If m_blnValidatingFieldChange = True Then
     Exit Property
  End If

  If m_eEditMode = adEditInProgress Or m_eEditMode = adEditAdd Then
     m_blnIgnoreFieldChange = True
     m_recManagedObjects.Fields(g_pFieldUnitsOnOrder) = v_lngNewUnitsOnOrder

  ElseIf m_eEditMode = adEditNone Then
     Err.Raise 1001, "UnitOnOrder Let:", GetErrorText(errChangeFieldNoEdit)

  End If

  Exit Property

UnitsOnOrderLetError:

  Err.Raise Err.Number, "Product.UnitsOnOrder.Let " & Err.Source, Err.Description

End Property
Public Property Get ReorderLevel() As Long

  On Error Resume Next

  ReorderLevel = m_recManagedObjects.Fields(g_pFieldReorderLevel)

  If Err.Number <> 0 Then

     If Err.Number <> 3265 Then
        Err.Raise Err.Number, "Product.ReorderLevel.Get" & _
            Err.Source, Err.Description
     End If

  End If

End Property

Public Property Let ReorderLevel(ByVal v_lngNewReorderLevel As Long)

  On Error GoTo ReorderLevelLetError

  If m_blnValidatingFieldChange = True Then
     Exit Property
  End If

  If m_eEditMode = adEditInProgress Or m_eEditMode = adEditAdd Then
     m_blnIgnoreFieldChange = True
     m_recManagedObjects.Fields(g_pFieldReorderLevel) = v_lngNewReorderLevel

  ElseIf m_eEditMode = adEditNone Then
     Err.Raise 1001, "ReorderLevel Let:", GetErrorText(errChangeFieldNoEdit)

  End If

  Exit Property

ReorderLevelLetError:

  Err.Raise Err.Number, "Product.ReorderLevel.Let " & Err.Source, _
     Err.Description

End Property
Public Property Get Discontinued() As Boolean

  On Error Resume Next

  Discontinued = m_recManagedObjects.Fields(g_pFieldDiscontinued)

  If Err.Number <> 0 Then

     If Err.Number <> 3265 Then
        Err.Raise Err.Number, "Product.Discontinued.Get" & _
            Err.Source, Err.Description
     End If

  End If

End Property

Public Property Let Discontinued(ByVal v_blnNewDiscontinued As Boolean)

  On Error GoTo DiscontinuedLetError

  If m_blnValidatingFieldChange = True Then
     Exit Property
  End If

  If m_eEditMode = adEditInProgress Or m_eEditMode = adEditAdd Then
     m_blnIgnoreFieldChange = True
     m_recManagedObjects.Fields(g_pFieldDiscontinued) = v_blnNewDiscontinued

  ElseIf m_eEditMode = adEditNone Then
     Err.Raise 1001, "Discontinued Let:", GetErrorText(errChangeFieldNoEdit)

  End If

  Exit Property

DiscontinuedLetError:

  Err.Raise Err.Number, "Product.Discontinued.Let " & Err.Source, _
     Err.Description

End Property
Public Property Get ProductID() As Long
    
  On Error Resume Next

  ProductID = m_recManagedObjects.Fields(g_pFieldProductID)
    
  If Err.Number <> 0 Then

     If Err.Number <> 3265 Then
        Err.Raise Err.Number, "clsProduct.ProductID.Get" & _
            Err.Source, Err.Description
     End If

  End If

End Property
Public Property Get ProductName() As String

  On Error Resume Next

  ProductName = m_recManagedObjects.Fields(g_pFieldProductName)

  If Err.Number <> 0 Then

     If Err.Number <> 3265 Then
        Err.Raise Err.Number, "Products.ProductName", Err.Description
     End If

  End If

End Property

Public Property Let ProductName(ByVal v_strNewProductName As String)
   
  On Error GoTo ContactTitleLetError

  If m_blnValidatingFieldChange = True Then
     Exit Property
   End If

  If m_eEditMode = adEditInProgress Or m_eEditMode = adEditAdd Then
     m_blnIgnoreFieldChange = True
     m_recManagedObjects.Fields(g_pFieldProductName) = v_strNewProductName

  ElseIf m_eEditMode = adEditNone Then
     Err.Raise 1001, "ProductName Let:", GetErrorText(errChangeFieldNoEdit)

  End If

  Exit Property

ContactTitleLetError:

  Err.Raise Err.Number, "ContactTitle Let " & Err.Source, Err.Description

End Property
Friend Function ValidateFields(ByVal v_vFields As Variant, ByVal _
  pRecordset As ADODB.Recordset, Optional ByRef r_sErrorDetails) As Boolean

  On Error GoTo ValidateFieldsError

  m_blnValidatingFieldChange = True

  Select Case LCase(v_vFields(0).Name)

    Case g_pFieldProductName
         ProductName = pRecordset.Fields(g_pFieldProductName)

    Case g_pFieldProductID
         ValidateFields = True

    Case g_pFieldUnitPrice
         UnitPrice = pRecordset.Fields(UnitPrice)
 
    Case g_pFieldDiscontinued
         Discontinued = pRecordset.Fields(g_pFieldDiscontinued)

    Case g_pFieldSupplierID
         SupplierID = pRecordset.Fields(g_pFieldSupplierID)

    Case g_pFieldSupplierID
         SupplierID = pRecordset.Fields(g_pFieldSupplierID)
        
  End Select

  m_blnValidatingFieldChange = False
  ValidateFields = True

  Exit Function

ValidateFieldsError:

  m_blnValidatingFieldChange = False
  ValidateFields = False
  Err.Clear

End Function
Public Property Get EditMode() As ADODB.EditModeEnum

  EditMode = m_eEditMode

End Property

Friend Property Let EditMode(ByVal v_eNewEditMode As ADODB.EditModeEnum)

  m_eEditMode = v_eNewEditMode

  RaiseEvent EditInProgress(v_eNewEditMode)

End Property

Friend Property Get ItemsRecordset() As ADODB.Recordset

  Set ItemsRecordset = m_recManagedObjects

End Property

Friend Property Set ItemsRecordset(ByVal v_recNewRecordset As ADODB.Recordset)

  Set m_recManagedObjects = v_recNewRecordset

End Property

Friend Property Let ItemsDataMember(ByVal v_strNewOrderDataMember As String)

  m_strManagedObjectDataMember = v_strNewOrderDataMember

End Property

Friend Property Get ItemsDataMember() As String

  ItemsDataMember = m_strManagedObjectDataMember

End Property
Private Sub Class_GetDataMember(DataMember As String, Data As Object)

  Set Data = m_recManagedObjects

End Sub

Private Sub Class_Initialize()

  m_blnValidatingFieldChange = False
  m_blnIgnoreFieldChange = False
  m_blnInFieldChange = False
  m_eEditMode = adEditNone
  Set m_recManagedObjects = New ADODB.Recordset

End Sub

Private Sub Class_Terminate()

  If Not m_recManagedObjects Is Nothing Then

     If ItemsRecordset.State = adStateOpen Then

       If Not ItemsRecordset.BOF And Not ItemsRecordset.EOF Then
       If ItemsRecordset.EditMode <> adEditNone Then
          ItemsRecordset.CancelUpdate
       End If
       End If
       ItemsRecordset.Close

     End If

     Set m_recManagedObjects = Nothing

  End If

End Sub

Friend Sub RefreshDataMember()

  DataMemberChanged ItemsDataMember

End Sub

Private Sub m_recManagedObjects_FieldChangeComplete(ByVal cFields As _
    Long, ByVal Fields As Variant, ByVal pError As ADODB.Error, adStatus _
    As ADODB.EventStatusEnum, ByVal pRecordset As ADODB.Recordset)

  If m_blnIgnoreFieldChange = True Then
     m_blnIgnoreFieldChange = False
     DataMemberChanged ItemsDataMember
     RaiseEvent RefreshDataMember
     Exit Sub
  End If

  If m_blnInFieldChange = True Then
     m_blnInFieldChange = False
     Exit Sub
  End If
    
  If m_recManagedObjects.RecordCount = 0 Or m_recManagedObjects.EditMode _
        = adEditDelete Or m_recManagedObjects.State <> adStateOpen Then
     Exit Sub
  End If
    
  If EditMode = adEditNone Then
     EditMode = adEditInProgress
     EditMode = EditMode
  End If

    
  If ValidateFields(Fields, pRecordset) = False Then
     m_blnInFieldChange = True
     m_recManagedObjects.Fields(Fields(0).Name).Value = _
         pRecordset.Fields(Fields(0).Name).UnderlyingValue
     DataMemberChanged ItemsDataMember
     RaiseEvent RefreshDataMember
     m_blnInFieldChange = False
  End If

End Sub

